<?php
    /**
     * install
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2024
     * @var object $services
     * @version 6.20: install.php, v1.00 1/6/2024 7:06 PM Gewa Exp $
     *
     */
    
    use Wojo\File\File;
    use Wojo\Language\Language;
    use Wojo\Url\Url;
    
    const _WOJO = true;
    include('init.php');
    
    if (isset($_POST['submit'])) {
        $sqlData = File::parseSQL('install.sql');
        
        foreach ($sqlData as $sql) {
            $services->database->rawQuery($sql)->run();
        }
        
        if ($langdata = $services->database->select(Language::lTable, array('abbr'))->where()->run('abbr', 'en', '<>')) {
            foreach ($langdata as $lang) {
                $flag_id = $lang->abbr;
                include_once(BASEPATH . '/view/admin/modules/portfolio/_addLanguage.lang.php');
            }
        }
        
        Url::redirect(SITEURL . '/install.php?install=done');
    }
?>
<!doctype html>
<html lang="en">
<head>
   <meta charset="utf-8">
   <title>Module Install - Portfolio Manager</title>
   <style>
      @import url(https://fonts.googleapis.com/css?family=Raleway:400,100,300,600,700);
      body {
         font-family: Raleway, Arial, Helvetica, sans-serif;
         font-size: 14px;
         line-height: 1.3em;
         color: #FFF;
         background-color: #222;
         font-weight: 300;
         margin: 0;
         padding: 0
      }
      #wrap {
         width: 800px;
         margin-top: 150px;
         margin-right: auto;
         margin-left: auto;
         background-color: #208ed3;
         box-shadow: 2px 2px 2px 2px rgba(0, 0, 0, 0.1);
         border: 2px solid #111;
         border-radius: 3px
      }
      header {
         background-color: #145983;
         font-size: 26px;
         font-weight: 200;
         padding: 35px
      }
      .line {
         height: 2px;
         background: linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 47%, rgba(255, 255, 255, 0) 100%)
      }
      .line2 {
         position: absolute;
         left: 200px;
         height: 360px;
         width: 2px;
         background: linear-gradient(to bottom, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 47%, rgba(255, 255, 255, 0) 100%);
         display: block
      }
      #content {
         position: relative;
         padding: 45px 20px
      }
      #content .left {
         float: left;
         width: 200px;
         height: 400px;
         background-image: url(assets/images/installer.png);
         background-repeat: no-repeat;
         background-position: 0 center;
         background-size: 80%;
      }
      #content .right {
         margin-left: 200px
      }
      h4 {
         font-size: 18px;
         font-weight: 300;
         margin: 0 0 40px;
         padding: 0
      }
      p.info,
      p.success {
         background-color: #383838;
         border-radius: 3px;
         box-shadow: 1px 1px 1px 1px rgba(0, 0, 0, 0.1);
         padding: 10px
      }
      p.success {
         background-color: #4CAF50;
      }
      p.info span,
      p.success span {
         display: block;
         float: left;
         padding: 10px;
         background: rgba(255, 255, 255, 0.1);
         margin-left: -10px;
         margin-top: -10px;
         border-radius: 3px 0 0 3px;
         margin-right: 5px;
         border-right: 1px solid rgba(255, 255, 255, 0.05)
      }
      footer {
         background-color: #383838;
         padding: 20px
      }
      form {
         display: inline-block;
         float: right;
         margin: 0;
         padding: 0
      }
      .button {
         border: 2px solid #222;
         font-family: Raleway, Arial, Helvetica, sans-serif;
         font-size: 14px;
         color: #FFF;
         background-color: #208ED3;
         text-align: center;
         cursor: pointer;
         font-weight: 600;
         -webkit-transition: all .35s ease;
         -moz-transition: all .35s ease;
         -o-transition: all .35s ease;
         transition: all .35s ease;
         outline: none;
         margin: 0;
         padding: 5px 20px
      }
      .button:hover {
         background-color: #222;
         -webkit-transition: all .55s ease;
         -moz-transition: all .55s ease;
         -o-transition: all .35s ease;
         transition: all .55s ease;
         outline: none
      }
      .clear {
         font-size: 0;
         line-height: 0;
         clear: both;
         height: 0
      }
      .clearfix:after {
         content: ".";
         display: block;
         height: 0;
         clear: both;
         visibility: hidden;
      }
      a {
         text-decoration: none;
         float: right
      }
   </style>
</head>
<body>
<div id="wrap">
   <header>Welcome to CMS pro Module Install Wizard</header>
   <div class="line"></div>
   <div id="content">
      <div class="left">
         <div class="line2"></div>
      </div>
      <div class="right">
         <h4>Module Install - Portfolio Manager <small>v6.20</small></h4>
          <?php if (isset($_GET['install']) && $_GET['install'] == 'done'): ?>
             <p class="success"><span>Success!</span>Installation Completed. Please delete install (.php,.sql)</p>
          <?php else: ?>
             <p class="info"><span>Warning!</span>Please make sure you have performed full backup, including database!!!</p>
             <p style="margin-top:60px">When ready click Install button.</p>
             <p><span>Please be patient, and<strong> DO NOT</strong> Refresh your browser.<br>
        This process might take a while</span>.</p>
          <?php endif; ?>
      </div>
   </div>
   <div class="clear"></div>
   <footer class="clearfix"><small>current <b>cms v.<?php echo $services->core->wojov; ?></b></small>
       <?php if (isset($_GET['install']) && $_GET['install'] == 'done'): ?>
          <a href="admin/" class="button">Back to admin panel</a>
       <?php else: ?>
          <form method="post" name="upgrade_form">
             <input name="submit" type="submit" class="button" value="Install Module" id="submit"/>
          </form>
       <?php endif; ?>
   </footer>
</div>
</body>
</html>