DROP TABLE IF EXISTS `mod_portfolio`;
CREATE TABLE IF NOT EXISTS `mod_portfolio` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title_en` varchar(100) NOT NULL,
  `slug_en` varchar(100) NOT NULL,
  `body_en` text,
  `client` varchar(100) DEFAULT NULL,
  `thumb` varchar(60) DEFAULT NULL,
  `file` varchar(60) DEFAULT NULL,
  `images` blob,
  `custom_fields` varchar(250) DEFAULT NULL,
  `keywords_en` varchar(200) DEFAULT NULL,
  `description_en` text,
  `is_featured` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `mod_portfolio_categories`;
CREATE TABLE IF NOT EXISTS `mod_portfolio_categories` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_en` varchar(100) NOT NULL,
  `slug_en` varchar(100) NOT NULL,
  `keywords_en` varchar(100) DEFAULT NULL,
  `description_en` text,
  `sorting` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `mod_portfolio_gallery`;
CREATE TABLE IF NOT EXISTS `mod_portfolio_gallery` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(60) DEFAULT NULL,
  `sorting` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

INSERT INTO `modules` (`title_en`, `info_en`, `modalias`, `hasconfig`, `hascoupon`, `hasfields`, `system`, `content`, `parent_id`, `is_menu`, `is_builder`, `keywords_en`, `description_en`, `icon`, `ver`, `created`, `active`) VALUES('Portfolio', 'Display detailed information about your work!', 'portfolio', 1, 1, 1, 1, 1, 0, 1, 0, NULL, NULL, 'portfolio/thumb.svg', '6.20', '2024-01-05 18:37:21', 1);

INSERT INTO `plugins` (`title_en`, `body_en`, `jscode`, `show_title`, `alt_class`, `system`, `cplugin`, `info_en`, `plugalias`, `hasconfig`, `multi`, `parent_id`, `plugin_id`, `groups`, `created`, `icon`, `ver`, `active`) VALUES
('Our Branding works', NULL, NULL, 0, NULL, 1, 1, NULL, 'portfolio/latest', 0, 0, 0, 0, 'portfolio', '2024-01-18 08:28:53', 'portalatest/thumb.svg', '1.00', 1),
('Portfolio Simple', NULL, NULL, 0, NULL, 1, 1, NULL, 'portfolio/simple', 0, 0, 0, 0, 'portfolio', '2024-01-17 11:16:10', 'portasimple/thumb.svg', '1.00', 1);