<?php
   /**
    * _portfolio_edit
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _portfolio_edit.tpl.php, v1.00 5/16/2023 6:25 PM Gewa Exp $
    *
    */

   use Wojo\Date\Date;
   use Wojo\Language\Language;
   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Url\Url;
   use Wojo\Utility\Utility;
   use Wojo\Validator\Validator;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo form">
      <div class="wojo lang tabs">
         <ul class="nav">
            <?php foreach ($this->langlist as $lang): ?>
               <li<?php echo ($lang->abbr == $this->core->lang)? ' class="active"' : null; ?>>
                  <a class="lang-color <?php echo Utility::colorToWord($lang->color); ?>"
                     data-tab="lang_<?php echo $lang->abbr; ?>"><span
                       class="flag icon <?php echo $lang->abbr; ?>"></span><?php echo $lang->name; ?></a>
               </li>
            <?php endforeach; ?>
         </ul>
         <div class="tab spaced">
            <?php foreach ($this->langlist as $lang): ?>
               <div data-tab="lang_<?php echo $lang->abbr; ?>" class=" item">
                  <div class="wojo fields">
                     <div class="field">
                        <label><?php echo Language::$word->NAME; ?>
                           <small><?php echo $lang->abbr; ?></small>
                           <i class="icon asterisk"></i>
                        </label>
                        <div class="wojo large basic input">
                           <input type="text" placeholder="<?php echo Language::$word->NAME; ?>"
                                  value="<?php echo $this->data->{'title_' . $lang->abbr}; ?>"
                                  name="title_<?php echo $lang->abbr ?>">
                        </div>
                     </div>
                     <div class="field">
                        <label><?php echo Language::$word->ITEMSLUG; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <div class="wojo large basic input">
                           <input type="text" placeholder="<?php echo Language::$word->ITEMSLUG; ?>"
                                  value="<?php echo $this->data->{'slug_' . $lang->abbr}; ?>"
                                  name="slug_<?php echo $lang->abbr ?>">
                        </div>
                     </div>
                  </div>
                  <div class="wojo fields">
                     <div class="field">
                  <textarea class="bodypost"
                            name="body_<?php echo $lang->abbr; ?>"><?php echo Url::out_url($this->data->{'body_' . $lang->abbr}); ?></textarea>
                     </div>
                  </div>
                  <div class="wojo fields">
                     <div class="field basic">
                        <label><?php echo Language::$word->METAKEYS; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>"
                                  name="keywords_<?php echo $lang->abbr; ?>"><?php echo $this->data->{'keywords_' . $lang->abbr}; ?></textarea>
                     </div>
                     <div class="field basic">
                        <label><?php echo Language::$word->METADESC; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>"
                                  name="description_<?php echo $lang->abbr; ?>"><?php echo $this->data->{'description_' . $lang->abbr}; ?></textarea>
                     </div>
                  </div>
               </div>
            <?php endforeach; ?>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB1; ?></label>
            <input type="text" placeholder="<?php echo Language::$word->_MOD_PF_SUB1; ?>"
                   value="<?php echo $this->data->client; ?>" name="client">
         </div>
         <div class="field">
            <label><?php echo Language::$word->CATEGORY; ?></label>
            <select name="category_id">
               <?php echo Utility::loopOptions($this->categories, 'id', 'name' . Language::$lang, $this->data->category_id); ?>
            </select>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->FILE; ?></label>
            <input type="file" data-buttonText="<?php echo Language::$word->BROWSE; ?>" name="file" id="file" class="filestyle"
                   data-input="false" data-badge="true">
            <div class="margin-top">
               <label class="label"><?php echo Language::$word->CREATED; ?></label>
               <div class="wojo icon input">
                  <input name="created" type="text" placeholder="<?php echo Language::$word->CREATED; ?>"
                         value="<?php echo Date::doDate('calendar', $this->data->created); ?>" class="datepick" readonly>
                  <i class="icon calendar date"></i>
               </div>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->MAINIMAGE; ?></label>
            <input type="file" name="thumb" data-class="left" data-type="image"
                   data-exist="<?php echo Portfolio::hasThumb($this->data->thumb, $this->data->id); ?>"
                   accept="image/png, image/jpeg">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB11; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="is_featured" type="radio" value="1"
                      id="is_featured_1" <?php echo Validator::getChecked($this->data->is_featured, 1); ?>>
               <label for="is_featured_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="is_featured" type="radio" value="0"
                      id="is_featured_0" <?php echo Validator::getChecked($this->data->is_featured, 0); ?>>
               <label for="is_featured_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
      </div>
   </div>
   <div class="wojo form segment margin-bottom">
      <h5><?php echo Language::$word->CF_TITLE; ?></h5>
      <?php echo $this->custom_fields; ?></div>
   <div class="wojo form segment margin-bottom">
      <div class="field">
         <label><?php echo Language::$word->IMAGES; ?></label>
         <input type="file" name="images" id="images" data-input="false"
                data-buttonText="<?php echo Language::$word->MULTIPLE; ?>"
                data-fields='{"action":"images","id":<?php echo $this->data->id; ?>}' class="filestyle" multiple>
         <div class="scrollbox margin-top height300">
            <div class="wojo sortable row blocks phone-1 mobile-2 tablet-3 screen-5 gutters" id="sortable">
               <?php if ($this->images): ?>
                  <?php foreach ($this->images as $i => $irow): ?>
                     <div class="columns" id="item_<?php echo $irow->id; ?>" data-id="<?php echo $irow->id; ?>">
                        <div class="wojo compact segment center-align">
                           <div class="handle">
                              <i class="icon grip horizontal"></i>
                           </div>
                           <img src="<?php echo Portfolio::hasThumb($irow->name, $this->data->id); ?>" alt=""
                                class="wojo rounded image">
                           <a data-set='{"option":[{"action": "delete","id":<?php echo $irow->id; ?>, "type":"image"}], "url":"modules/portfolio/action/","action":"delete", "parent":"#item_<?php echo $irow->id; ?>"}'
                             class="wojo mini icon negative simple button data">
                              <i class="icon x alt"></i>
                           </a>
                        </div>
                     </div>
                  <?php endforeach; ?>
               <?php endif; ?>
            </div>
         </div>
      </div>
   </div>
   <div class="center-align">
      <a href="<?php echo Url::url('admin/modules', 'portfolio/'); ?>"
         class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-route="admin/modules/portfolio/action/" data-action="update" name="dosubmit"
              class="wojo primary button"><?php echo Language::$word->_MOD_PF_UPDATEITM; ?></button>
   </div>
   <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
</form>
