<?php
   /**
    * _portfolio_list
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _portfolio_list.tpl.php, v1.00 5/14/2023 7:25 PM Gewa Exp $
    *
    */

   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Core\Router;
   use Wojo\Language\Language;
   use Wojo\Url\Url;
   use Wojo\Validator\Validator;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row gutters align-middle">
   <div class="columns screen-40 tablet-40 mobile-100">
      <form method="post" id="wojo_form" name="wojo_form" class="wojo form">
         <div class="wojo small action input">
            <input name="find" placeholder="<?php echo Language::$word->SEARCH; ?>" type="text">
            <button class="wojo icon primary inverted button">
               <i class="icon search"></i>
            </button>
         </div>
      </form>
   </div>
   <div class="columns mobile-hide phone-hide"></div>
   <div class="columns auto mobile-50 phone-100">
      <a href="<?php echo Url::url('admin/modules/portfolio', 'new/'); ?>" class="wojo small secondary fluid button">
         <i class="icon plus alt"></i><?php echo Language::$word->_MOD_PF_ADD; ?></a>
   </div>
   <div class="columns auto mobile-25 phone-50">
      <a class="wojo small secondary passive inverted icon button">
         <i class="icon list"></i>
      </a>
      <a href="<?php echo Url::url('admin/modules/portfolio'); ?>" class="wojo small primary icon button">
         <i class="icon grid"></i>
      </a>
   </div>
   <div class="columns auto mobile-25 phone-50">
      <a data-wdropdown="#dropdown-portMenu" class="wojo small basic primary icon button">
         <i class="icon three dots vertical"></i>
      </a>
      <div class="wojo small dropdown menu top-right" id="dropdown-portMenu">
         <a class="item" href="<?php echo Url::url('admin/modules/portfolio', 'settings/'); ?>">
            <i class="icon sliders horizontal"></i>
            <?php echo Language::$word->SETTINGS; ?></a>
         <a class="item" href="<?php echo Url::url('admin/modules/portfolio', 'categories/'); ?>">
            <i class="icon unordered list"></i>
            <?php echo Language::$word->CATEGORIES; ?></a>
      </div>
   </div>
</div>
<div class="center-align">
   <div class="wojo small divided horizontal list">
      <div class="disabled item text-weight-700">
         <?php echo Language::$word->SORTING_O; ?>
      </div>
      <a href="<?php echo Url::url(Router::$path); ?>" class="item<?php echo Url::setActive('order', false); ?>">
         <?php echo Language::$word->RESET; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=hits|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'hits'); ?>">
         <?php echo Language::$word->HITS; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=category_id|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'category_id'); ?>">
         <?php echo Language::$word->CATEGORY; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=client|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'client'); ?>">
         <?php echo Language::$word->_MOD_PF_SUB1; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=title|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'title'); ?>">
         <?php echo Language::$word->NAME; ?>
      </a>
      <a href="<?php echo Url::sortItems(Url::url(Router::$path), 'order'); ?>" class="item">
         <i class="icon caret <?php echo Url::ascDesc('order'); ?> link"></i>
      </a>
   </div>
</div>
<div class="center-align margin-vertical">
   <?php echo Validator::alphaBits(Url::url(Router::$path)); ?>
</div>
<?php if (!$this->data): ?>
   <div class="center-align">
      <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
      <div class="margin-small-top">
         <p class="wojo small icon alert inverted attached compact message">
            <i class="icon exclamation triangle"></i><?php echo Language::$word->_MOD_PF_NOPROJ; ?></p>
      </div>
   </div>
<?php else: ?>
   <?php foreach ($this->data as $row): ?>
      <div class="wojo horizontal framed card" id="item_<?php echo $row->id; ?>">
         <div class="row">
            <div class="columns screen-20">
               <img src="<?php echo Portfolio::hasThumb($row->thumb, $row->id); ?>" alt=""
                    class="wojo image left rounded fill">
            </div>
            <div class="columns">
               <div class="padding">
                  <p class="basic text-size-small">
                     <a href="<?php echo Url::url('admin/modules/portfolio/category', $row->category_id); ?>"><?php echo $row->name; ?></a>
                  </p>
                  <small><?php echo Language::$word->_MOD_PF_SUB1; ?>: <?php echo $row->client?: '-/-'; ?></small>
                  <h5>
                     <a href="<?php echo Url::url('admin/modules/portfolio/edit', $row->id); ?>"><?php echo $row->title; ?></a>
                  </h5>
               </div>
            </div>
            <div class="columns auto center-align">
               <div class="padding">
                  <a class="wojo  primary inverted icon button"
                     href="<?php echo Url::url('admin/modules/portfolio/edit', $row->id); ?>">
                     <i class="icon pencil"></i>
                  </a>
                  <a data-set='{"option":[{"action": "deleteItem","title": "<?php echo Validator::sanitize($row->title, 'chars'); ?>","id":<?php echo $row->id; ?>, "type":"item"}],"action":"delete","parent":"#item_<?php echo $row->id; ?>","url":"modules/portfolio/action/"}'
                    class="wojo negative inverted icon button data">
                     <i class="icon trash"></i>
                  </a>
               </div>
            </div>
         </div>
      </div>
   <?php endforeach; ?>
<?php endif; ?>
<div class="padding-small-horizontal">
   <div class="row gutters align-middle">
      <div class="columns mobile-100 phone-100">
         <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
            / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
      </div>
      <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
   </div>
</div>