<?php
   /**
    * _portfolio_new
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _portfolio_new.tpl.php, v1.00 5/14/2023 3:20 PM Gewa Exp $
    *
    */

   use Wojo\Core\Session;
   use Wojo\Date\Date;
   use Wojo\Language\Language;
   use Wojo\Url\Url;
   use Wojo\Utility\Utility;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo form">
      <div class="wojo lang tabs">
         <ul class="nav">
            <?php foreach ($this->langlist as $lang): ?>
               <li<?php echo ($lang->abbr == $this->core->lang)? ' class="active"' : null; ?>>
                  <a class="lang-color <?php echo Utility::colorToWord($lang->color); ?>"
                     data-tab="lang_<?php echo $lang->abbr; ?>"><span
                       class="flag icon <?php echo $lang->abbr; ?>"></span><?php echo $lang->name; ?></a>
               </li>
            <?php endforeach; ?>
         </ul>
         <div class="tab spaced">
            <?php foreach ($this->langlist as $lang): ?>
               <div data-tab="lang_<?php echo $lang->abbr; ?>" class="item">
                  <div class="wojo fields">
                     <div class="field">
                        <label><?php echo Language::$word->NAME; ?>
                           <small><?php echo $lang->abbr; ?></small>
                           <i class="icon asterisk"></i>
                        </label>
                        <div class="wojo large basic input">
                           <input type="text" placeholder="<?php echo Language::$word->NAME; ?>"
                                  name="title_<?php echo $lang->abbr ?>">
                        </div>
                     </div>
                     <div class="field">
                        <label><?php echo Language::$word->ITEMSLUG; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <div class="wojo large basic input">
                           <input type="text" placeholder="<?php echo Language::$word->ITEMSLUG; ?>"
                                  name="slug_<?php echo $lang->abbr ?>">
                        </div>
                     </div>
                  </div>
                  <div class="wojo fields">
                     <div class="field">
                        <textarea class="bodypost" name="body_<?php echo $lang->abbr; ?>"></textarea>
                     </div>
                  </div>
                  <div class="wojo fields">
                     <div class="field">
                        <label><?php echo Language::$word->METAKEYS; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>"
                                  name="keywords_<?php echo $lang->abbr; ?>"></textarea>
                     </div>
                     <div class="field">
                        <label><?php echo Language::$word->METADESC; ?>
                           <small><?php echo $lang->abbr; ?></small>
                        </label>
                        <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>"
                                  name="description_<?php echo $lang->abbr; ?>"></textarea>
                     </div>
                  </div>
               </div>
            <?php endforeach; ?>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB1; ?></label>
            <input type="text" placeholder="<?php echo Language::$word->_MOD_PF_SUB1; ?>" name="client">
         </div>
         <div class="field">
            <label><?php echo Language::$word->CATEGORY; ?></label>
            <select name="category_id">
               <?php echo Utility::loopOptions($this->categories, 'id', 'name' . Language::$lang); ?>
            </select>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->FILE; ?></label>
            <input type="file" data-buttonText="<?php echo Language::$word->BROWSE; ?>" name="file" id="file" class="filestyle"
                   data-input="false" data-badge="true">
            <div class="margin-top">
               <label class="label"><?php echo Language::$word->CREATED; ?></label>
               <div class="wojo icon input">
                  <input name="created" type="text" placeholder="<?php echo Language::$word->CREATED; ?>"
                         value="<?php echo Date::doDate('calendar', Date::today()); ?>" readonly class="datepick">
                  <i class="icon calendar date"></i>
               </div>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->MAINIMAGE; ?></label>
            <input type="file" data-class="left" name="thumb" data-type="image" accept="image/png, image/jpeg">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB11; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="is_featured" type="radio" value="1" id="is_featured_1" checked="checked">
               <label for="is_featured_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="is_featured" type="radio" value="0" id="is_featured_0">
               <label for="is_featured_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
      </div>
   </div>
   <div class="wojo form segment margin-bottom">
      <h5><?php echo Language::$word->CF_TITLE; ?></h5>
      <?php echo $this->custom_fields; ?></div>
   <div class="wojo form segment margin-bottom">
      <div class="field">
         <label><?php echo Language::$word->IMAGES; ?></label>
         <input type="file" name="images" id="images" data-input="false"
                data-buttonText="<?php echo Language::$word->MULTIPLE; ?>"
                data-fields='{"action":"images","id":<?php echo Session::get('foliotoken'); ?>}'
                class="filestyle" multiple>
         <div class="scrollbox margin-top height300">
            <div class="wojo sortable row blocks phone-1 mobile-2 tablet-3 screen-5 gutters" id="sortable"></div>
         </div>
      </div>
   </div>
   <div class="center-align">
      <a href="<?php echo Url::url('admin/modules', 'portfolio/'); ?>"
         class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-route="admin/modules/portfolio/action/" data-action="add" name="dosubmit"
              class="wojo primary button"><?php echo Language::$word->_MOD_PF_NEWITM; ?></button>
   </div>
</form>