<?php
   /**
    * _portfolio_settings
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _portfolio_settings.tpl.php, v1.00 5/17/2023 8:12 PM Gewa Exp $
    *
    */

   use Wojo\Language\Language;
   use Wojo\Url\Url;
   use Wojo\Validator\Validator;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo form">
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->THUMB_W; ?>
               <i class="icon asterisk"></i>
            </label>
            <div class="wojo labeled input">
               <input placeholder="<?php echo Language::$word->THUMB_W; ?>" value="<?php echo $this->data->thumb_w; ?>"
                      name="thumb_w" type="text">
               <div class="wojo simple label"> px</div>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->THUMB_H; ?>
               <i class="icon asterisk"></i>
            </label>
            <div class="wojo labeled input">
               <input placeholder="<?php echo Language::$word->THUMB_H; ?>" value="<?php echo $this->data->thumb_h; ?>"
                      name="thumb_h" type="text">
               <div class="wojo simple label"> px</div>
            </div>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB8; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_cats" type="radio" value="1"
                      id="show_cats_1" <?php echo Validator::getChecked($this->data->show_cats, 1); ?>>
               <label for="show_cats_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_cats" type="radio" value="0"
                      id="show_cats_0" <?php echo Validator::getChecked($this->data->show_cats, 0); ?>>
               <label for="show_cats_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB9; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_sort" type="radio" value="1"
                      id="show_sort_1" <?php echo Validator::getChecked($this->data->show_sort, 1); ?>>
               <label for="show_sort_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_sort" type="radio" value="0"
                      id="show_sort_0" <?php echo Validator::getChecked($this->data->show_sort, 0); ?>>
               <label for="show_sort_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB10; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_featured" type="radio" value="1"
                      id="show_featured_1" <?php echo Validator::getChecked($this->data->show_featured, 1); ?>>
               <label for="show_featured_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_featured" type="radio" value="0"
                      id="show_featured_0" <?php echo Validator::getChecked($this->data->show_featured, 0); ?>>
               <label for="show_featured_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB12; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="social" type="radio" value="1"
                      id="social_1" <?php echo Validator::getChecked($this->data->social, 1); ?>>
               <label for="social_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="social" type="radio" value="0"
                      id="social_0" <?php echo Validator::getChecked($this->data->social, 0); ?>>
               <label for="social_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB13; ?></label>
            <input name="latest" type="range" min="1" max="20" step="5" value="<?php echo $this->data->latest; ?>" hidden
                   data-suffix=" itm" data-type="labels" data-labels="1,5,10,15,20">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB5; ?></label>
            <input name="ipc" type="range" min="1" max="20" step="5" value="<?php echo $this->data->ipc; ?>" hidden
                   data-suffix=" itm" data-type="labels" data-labels="1,5,10,15,20">
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_PF_SUB6; ?></label>
            <input name="fpp" type="range" min="1" max="20" step="5" value="<?php echo $this->data->fpp; ?>" hidden
                   data-suffix=" itm" data-type="labels" data-labels="1,5,10,15,20">
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_GA_COLS; ?>
               <i class="icon asterisk"></i>
            </label>
            <input name="cols" type="range" min="2" max="6" step="1" value="<?php echo $this->data->cols; ?>" hidden
                   data-suffix=" cols" data-type="labels" data-labels="2,4,6">
         </div>
      </div>
      <div class="wojo auto wide divider"></div>
      <div class="wojo fields">
         <div class="field basic">
            <label><?php echo Language::$word->_MOD_PF_SUB7; ?></label>
            <div class="row grid phone-1 mobile-2 tablet-2 screen-2 gutters" id="layoutMode">
               <div class="columns center-align">
                  <div class="wojo simple segment">
                     <a data-type="grid"
                        class="wojo inline-flex<?php echo ($this->data->layout == 'grid')? ' outline' : ''; ?>">
                        <img src="<?php echo AMODULEURL; ?>portfolio/view/images/grid.png" alt="">
                     </a>
                     <h6 class="margin-mini-top"><?php echo Language::$word->GRID; ?></h6>
                  </div>
               </div>
               <div class="columns center-align">
                  <div class="wojo simple segment">
                     <a data-type="list"
                        class="wojo inline-flex<?php echo ($this->data->layout == 'list')? ' outline' : ''; ?>">
                        <img
                          src="<?php echo AMODULEURL; ?>portfolio/view/images/list.png" alt="">
                     </a>
                     <h6 class="margin-mini-top"><?php echo Language::$word->LIST; ?></h6>
                  </div>
               </div>
            </div>
            <input type="hidden" name="layout" value="<?php echo $this->data->layout; ?>">
         </div>
      </div>
   </div>
   <div class="center-align">
      <a href="<?php echo Url::url('admin/modules', 'portfolio/'); ?>"
         class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-route="admin/modules/portfolio/action/" data-action="configuration" name="dosubmit"
              class="wojo primary button"><?php echo Language::$word->SAVECONFIG; ?></button>
   </div>
</form>