(function ($) {
   "use strict";
   $.Portfolio = function (settings) {
      let config = {
         url: "",
         lang: {
            delMsg3: "",
            delMsg8: "",
            canBtn: "",
            trsBtn: "",
            err: "",
            err1: ""
         }
      };
      if (settings) {
         $.extend(config, settings);
      }
const $sortable = $('#sortable')
      // select layout item
      $("#layoutMode").on('click', 'a', function () {
         $("#layoutMode .segment a").removeClass('outline');
         $(this).addClass('outline');
         $("input[name=layout]").val($(this).data('type'));
      });

      // sort categories
      if ($.inArray("category", $.url().segment()) !== -1 || $.inArray("categories", $.url().segment()) !== -1) {
         $('.wojo.nestable').sortable({
            animation: 150,
            fallbackOnBody: true,
            swapThreshold: 0.65,
            handle: ".handle",
            ghostClass: "ghost",
            onUpdate: function () {
               let items = this.toArray();
               $.ajax({
                  cache: false,
                  type: "post",
                  url: config.url,
                  dataType: "json",
                  data: {
                     action: "sort",
                     type: "categories",
                     sorting: items
                  }
               });
            },
         });
      }

      // sort images
      $sortable.sortable({
         ghostClass: "outline",
         handle: ".handle",
         animation: 600,
         onUpdate: function () {
            let order = this.toArray();
            $.post(config.url, {
               action: "sort",
               type: "images",
               sorting: order
            }, function () {
            }, "json");

         }
      });

      // add images
      $('#images').simpleUpload({
         url: config.url,
         dataType: "json",
         types: ['jpg', 'png', 'JPG', 'PNG'],
         error: function (error) {
            if (error.type === 'fileType') {
               $.wNotice({
                  autoclose: 4000,
                  type: "error",
                  title: config.lang.err,
                  text: config.lang.err1
               });
            }
         },
         beforeSend: function () {
            $sortable.closest('.segment').addClass('loading');
         },
         success: function (json) {
            if (json.type === "success") {
               let html = '';
               $.each(json.html, function (key, value) {
                  html += value;
               });
               $sortable.prepend(html).sortable();
            } else {
               $.wNotice({
                  autoclose: 6000,
                  type: "error",
                  title: json.title,
                  text: json.message
               });
            }
            $sortable.closest('.segment').removeClass('loading');
         }
      });
   };
})(jQuery);