<?php
   /**
    * _grid
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _grid.tpl.php, v1.00 6/15/2023 1:24 PM Gewa Exp $
    *
    */
   
   use Wojo\Core\Router;
   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Url\Url;
   use Wojo\Utility\Utility;
   
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php if ($this->rows): ?>
   <div class="mason <?php echo Utility::numberToWords($this->settings->cols); ?>">
      <?php foreach ($this->rows as $row): ?>
         <div class="item">
            <div class="wojo attached card">
               <a href="<?php echo Url::url(Router::$path, $row->slug); ?>">
                  <img src="<?php echo FMODULEURL . Portfolio::PORTDATA . $row->id . '/thumbs/' . $row->thumb; ?>" alt="" class="rounded-top">
               </a>
               <div class="content">
                  <div class="margin-small-bottom">
                     <a href="<?php echo Url::url(Router::$path . '/' . $this->core->modname['portfolio-cat'], $row->cslug); ?>" class="grey"><?php echo $row->ctitle; ?></a>
                  </div>
                  <h5 class="basic">
                     <a href="<?php echo Url::url(Router::$path, $row->slug); ?>">
                        <?php echo $row->title; ?>
                     </a>
                  </h5>
               </div>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
<?php endif; ?>