<?php
   /**
    * _list
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: _list.tpl.php, v1.00 6/15/2023 1:24 PM Gewa Exp $
    *
    */

   use Wojo\Core\Router;
   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Url\Url;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php if ($this->rows): ?>
   <div class="row grid screen-2 tablet-1 mobile-1 phone-1 gutters">
      <?php foreach ($this->rows as $row): ?>
         <div class="columns" id="item_<?php echo $row->id; ?>">
            <div class="wojo attached card">
               <div class="row">
                  <div class="columns screen-20 tablet-20 mobile-20 phone-100">
                     <a href="<?php echo Url::url(Router::$path, $row->slug); ?>" class="wojo fill image">
                        <img src="<?php echo FMODULEURL . Portfolio::PORTDATA . $row->id . '/thumbs/' . $row->thumb; ?>" class="rounded" alt="<?php echo $row->title; ?>">
                     </a>
                  </div>
                  <div class="columns phone-100">
                     <div class="padding">
                        <h5>
                           <a href="<?php echo Url::url(Router::$path, $row->slug); ?>">
                              <?php echo $row->title; ?>
                           </a>
                        </h5>
                        <a href="<?php echo Url::url(Router::$path . '/' . $this->core->modname['portfolio-cat'], $row->cslug); ?>" class="text-color-grey"><?php echo $row->ctitle; ?></a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
<?php endif; ?>