<?php
   /**
    * index
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: index.tpl.php, v1.00 6/15/2023 1:15 PM Gewa Exp $
    *
    */

   use Wojo\Core\Router;
   use Wojo\Date\Date;
   use Wojo\Language\Language;
   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Url\Url;

   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php switch (count($this->segments)): case 3: ?>
   <!-- Start Category -->
   <div class="padding-big-vertical">
      <?php if ($this->categories and $this->settings->show_cats): ?>
         <div class="center-align margin-vertical">
            <div class="wojo divided horizontal list">
               <a href="<?php echo Url::url($this->core->modname['portfolio']); ?>" class="disabled item text-weight-700">
                  <?php echo Language::$word->ALL; ?>
               </a>
               <?php foreach ($this->categories as $crow): ?>
                  <?php $active = (in_array($crow->{'slug' . Language::$lang}, $this->segments))? ' active' : null; ?>
                  <a href="<?php echo Url::url($this->core->modname['portfolio'] . '/' . $this->core->modname['portfolio-cat'], $crow->{'slug' . Language::$lang}); ?>" class="item<?php echo $active; ?>">
                     <?php echo $crow->{'name' . Language::$lang}; ?>
                  </a>
               <?php endforeach; ?>
            </div>
         </div>
      <?php endif; ?>
      <div class="margin-small-bottom">
         <h2><?php echo $this->row->{'name' . Language::$lang}; ?></h2>
         <p><?php echo $this->row->{'description' . Language::$lang}; ?></p>
      </div>
      <?php if ($this->rows): ?>
         <div class="mason big">
            <?php foreach ($this->rows as $row): ?>
               <div class="item">
                  <div class="wojo attached card">
                     <figure class="wojo hover">
                        <img src="<?php echo FMODULEURL . Portfolio::PORTDATA . $row->id . '/thumbs/' . $row->thumb; ?>" alt="" class="rounded">
                        <figcaption class="center-align">
                           <a href="<?php echo Url::url('/' . $this->core->modname['portfolio'], $row->slug); ?>" class="wojo small primary button"><?php echo $row->title; ?></a>
                        </figcaption>
                     </figure>
                  </div>
               </div>
            <?php endforeach; ?>
         </div>
         <div class="padding-small-horizontal">
            <div class="row gutters align-middle">
               <div class="columns auto mobile-100 phone-100">
                  <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
                     / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
               </div>
               <div class="columns mobile-100 right-align"><?php echo $this->pager->display(); ?></div>
            </div>
         </div>
      <?php endif; ?>
   </div>

   <?php break; ?>
<?php case 2: ?>
   <!-- Start Item -->
   <div class="padding-big-vertical">
      <div class="row big-gutters">
         <div class="columns screen-50 tablet-60 mobile-100 phone-100">
            <figure class="wojo hover">
               <img src="<?php echo FMODULEURL . Portfolio::PORTDATA . $this->row->id . '/thumbs/' . $this->row->thumb; ?>" alt="" class="wojo rounded image">
               <figcaption class="center aligned">
                  <a href="<?php echo FMODULEURL . Portfolio::PORTDATA . $this->row->id . '/' . $this->row->thumb; ?>" class="lightbox">
                     <i class="icon large circular primary url alt link"></i>
                  </a>
               </figcaption>
            </figure>
            <?php if ($this->images): ?>
               <?php foreach ($this->images as $img): ?>
                  <div class="small top margin">
                     <a href="<?php echo FMODULEURL . Portfolio::PORTDATA . $this->row->id . '/' . $img->name; ?>" data-gallery="portfolio" class="lightbox">
                        <img src="<?php echo Portfolio::hasThumb($img->name, $this->row->id); ?>" alt="<?php echo $this->row->{'title' . Language::$lang}; ?>" class="wojo basic rounded image">
                     </a>
                  </div>
               <?php endforeach; ?>
            <?php endif; ?>
         </div>
         <div class="columns screen-50 tablet-40 mobile-100 phone-100">
            <div class="wojo native sticky">
               <h2 class="text-color-primary">
                  <?php echo $this->row->{'title' . Language::$lang}; ?></h2>
               <?php echo Url::out_url($this->row->{'body' . Language::$lang}); ?>
               <div class="wojo divider"></div>
               <div class="wojo small relaxed list">
                  <div class="item">
                     <div class="content screen-20">
                        <span class="text-weight-600"><?php echo Language::$word->_MOD_PF_SUB1; ?></span>
                     </div>
                     <div class="content">
                        <span class="text-color-secondary"><?php echo $this->row->client; ?></span>
                     </div>
                  </div>
                  <?php echo $this->custom_fields; ?>
                  <div class="item">
                     <div class="content screen-20">
                        <span class="text-weight-600"><?php echo Language::$word->DATE; ?></span>
                     </div>
                     <div class="content">
                        <span class="text-color-secondary"><?php echo Date::doDate('short_date', $this->row->created); ?></span>
                     </div>
                  </div>
                  <?php if ($this->row->file): ?>
                     <div class="item align-middle">
                        <div class="content screen-20">
                           <span class="text-weight-600"><?php echo Language::$word->DOWNLOAD; ?></span>
                        </div>
                        <div class="content">
                           <a href="<?php echo FMODULEURL . Portfolio::FILEDATA . $this->row->file; ?>" class="wojo simple small icon button">
                              <i class="icon download"></i>
                           </a>
                        </div>
                     </div>
                  <?php endif; ?>
               </div>
               <?php if ($this->settings->social): ?>
                  <div class="wojo small divider"></div>
                  <div class="wojo small relaxed list">
                     <div class="item align-middle">
                        <div class="content screen-20">
                           <span class="text-weight-600">Share</span>
                        </div>
                        <div class="content">
                           <a href="//facebook.com/sharer/sharer.php?u=<?php echo Url::url(Router::$path); ?>" class="wojo small circular icon secondary spaced button">
                              <i class="icon facebook"></i>
                           </a>
                           <a href="//twitter.com/home?status=<?php echo Url::url(Router::$path); ?>&text=<?php echo $this->row->{'title' . Language::$lang}; ?>" class="wojo small circular icon secondary spaced button">
                              <i class="icon x_twitter"></i>
                           </a>
                           <a href="//linkedin.com/shareArticle?mini=true&url==<?php echo Url::url(Router::$path); ?>" class="wojo small circular icon secondary spaced button">
                              <i class="icon linkedin alt"></i>
                           </a>
                           <a href="//pinterest.com/pin/create/button/?url=<?php echo Url::url(Router::$path); ?>&media=<?php echo FMODULEURL . Portfolio::PORTDATA . $this->row->id . '/' . $this->row->thumb; ?>&description=<?php echo $this->row->{'title' . Language::$lang}; ?>" class="wojo small circular icon secondary button">
                              <i class="icon pinterest"></i>
                           </a>
                        </div>
                     </div>
                  </div>
               <?php endif; ?>
            </div>
         </div>
      </div>
   </div>

   <?php break; ?>
   <!-- Start default -->
<?php default: ?>

   <div class="padding-big-vertical">
      <?php if ($this->settings->show_sort): ?>
         <!-- Sorting -->
         <div class="center-align">
            <div class="wojo small divided horizontal list">
               <div class="disabled item">
                  <?php echo Language::$word->SORTING_O; ?>
               </div>
               <a href="<?php echo Url::url(Router::$path); ?>" class="item<?php echo Url::setActive('order', false); ?>">
                  <?php echo Language::$word->RESET; ?>
               </a>
               <a href="<?php echo Url::url(Router::$path, '?order=category_id|DESC'); ?>" class="item<?php echo Url::setActive('order', 'category_id'); ?>">
                  <?php echo Language::$word->CATEGORY; ?>
               </a>
               <a href="<?php echo Url::url(Router::$path, '?order=title|DESC'); ?>" class="item<?php echo Url::setActive('order', 'title'); ?>">
                  <?php echo Language::$word->NAME; ?>
               </a>
               <a href="<?php echo Url::sortItems(Url::url(Router::$path), 'order'); ?>" class="item">
                  <i class="icon caret <?php echo Url::ascDesc('order'); ?> link"></i>
               </a>
            </div>
         </div>
      <?php endif; ?>

      <?php if ($this->categories and $this->settings->show_cats): ?>
         <div class="center-align margin-vertical">
            <div class="wojo divided horizontal list">
               <a href="<?php echo Url::url(Router::$path); ?>" class="disabled item text-weight-700">
                  <?php echo Language::$word->ALL; ?>
               </a>
               <?php foreach ($this->categories as $crow): ?>
                  <a href="<?php echo Url::url(Router::$path . '/' . $this->core->modname['portfolio-cat'], $crow->{'slug' . Language::$lang}); ?>" class="item">
                     <?php echo $crow->{'name' . Language::$lang}; ?>
                  </a>
               <?php endforeach; ?>
            </div>
         </div>
      <?php endif; ?>

      <?php if ($this->settings->layout == 'grid'): ?>
         <?php include_once '_grid.tpl.php'; ?>
      <?php else: ?>
         <?php include_once '_list.tpl.php'; ?>
      <?php endif; ?>
   </div>

   <div class="padding-small-horizontal">
      <div class="row gutters align-middle">
         <div class="columns auto mobile-100 phone-100">
            <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
               / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
         </div>
         <div class="columns mobile-100 right-align"><?php echo $this->pager->display(); ?></div>
      </div>
   </div>

   <?php break; ?>
<?php endswitch; ?>