<?php
   /**
    * index
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 6.20: index.tpl.php, v1.00 6/15/2023 7:44 PM Gewa Exp $
    *
    */
   
   use Wojo\Module\Portfolio\Portfolio;
   use Wojo\Url\Url;
   use Wojo\Utility\Utility;
   
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
   
   $settings = Utility::findInArray($this->properties['all'], 'id', $this->properties['id']);
?>
<div class="wojo plugin<?php echo ($settings[0]->alt_class)? ' ' . $settings[0]->alt_class : null; ?>">
   <?php if ($rows = Portfolio::simpleItems()): ?>
      <div class="mason three">
         <?php foreach ($rows as $row): ?>
            <div class="item">
               <div class="wojo attached card">
                  <img src="<?php echo Portfolio::hasThumb($row->thumb, $row->id); ?>" alt="<?php echo $row->title; ?>" class="rounded-top">
                  <div class="content">
                     <p class="basic">
                        <a href="<?php echo Url::url($this->properties['core']->modname['portfolio'] . '/' . $this->core->modname['portfolio-cat'], $row->cslug); ?>" class="grey">
                           <?php echo $row->ctitle; ?>
                        </a>
                     </p>
                     <h6 class="basic">
                        <a href="<?php echo Url::url($this->properties['core']->modname['portfolio'], $row->slug); ?>">
                           <?php echo $row->title; ?>
                        </a>
                     </h6>
                  </div>
               </div>
            </div>
         <?php endforeach; ?>
      </div>
   <?php endif; ?>
</div>